
#ifndef CustomLensflaresDef
#define CustomLensflaresDef

#define LfpActivateLog

typedef char bool;

typedef struct LfpFlares
{
	int Count;
	var Aura;
	var* Flares;
	MATERIAL* MatAura;
}LfpFlares;



typedef struct LfpLight
{
	ENTITY* Ent;
	//int Order;
	
	var Vertex;
	bool IsCreated;
	bool IsClipped;
	int MainGrpId;
	int SubGrpId;

	var InitialRadius;		// Initial Wert fr die Reichweite zwischenspeichern
	var Radius;					// Reichweite von Skill5 fr die Firty-Flares, originalwert speichern
	bool IsSun;
	
	MATERIAL* MatAura;
	var Aura;

	LfpFlares* Sf;		// Normale Lens Flares
	LfpFlares* Df;		// Dirty Lens Flares

}LfpLight;

typedef struct LfpSubGroup
{
	int Id;
	char* Name;
	int Count;
	int LastOrderId;

	LfpLight* Lights;
}LfpSubGroup;

typedef struct LfpGroup
{
	int Id;
	char* Name;
	
	int Count;

	LfpSubGroup* Subs;

}LfpGroup;

typedef struct LfpStruct
{
	int GroupCount;
	int MaxLights;
	bool IsClipped;
	
	var SzHalfX; 			// Screensize * 0.5
	var SzHalfY;			// Screensize * 0.5
	
	var* DfScalesX;
	var* DfSizesX;
	var* DfSizesY;
	
	LfpGroup* Groups;		// Lichtgruppen
	
}LfpStruct;


LfpStruct* Lfp = NULL;








/* Bestimmt die Position der Lensflares oder Dusts von der Mitte des Bildschirms (Wert 1) nach oben oder unten. 
	Negative Werte gehen  nach unten */
#define LfpPivotDist skill1

/* Zustzliche Werte zum bewegen von View-Entitys auf der X bzw. Y-Achse  */
#define LfpAxisRl skill2
#define LfpAxisUd skill3
#define LfpMaxAlpha skill4

/* Speichert den Wert des letzten Alpha */
#define LfpTemp1 skill5
#define LfpTemp2 skill6
#define LfpTemp3 skill7

/* Zustzlich Pivot auf X/Y Achse bewegen */
#define LfpAxisPdRl skill8
#define LfpAxisPdUd skill9

/* XY Position der Flares, wenn die Kamera bewegt wird (bentigt fr die Lens Dust Effekte) */
#define LfpMidPosX skill60
#define LfpMidPosY skill61

/* XYZ Position des Lichtes (das Model mit der Aktion) */
#define LfpPosX skill70
#define LfpPosY skill71
#define LfpPosZ skill72

#define LfpVisAlpha skill90	
#define LfpId skill98			// Jedem Licht wird eine ID zugeordnet, die gleichzeitig Arrayindex ist
#define LfpTracePos skill100	// Entfernung zum Licht durch Trace





/* WED Skills */
#define LfpLightDist skill1		// Entfernung zum Model. Die Sonne hat immer den Wert 100.
#define LfpBlue skill2				// Rot, Grn, Blau Einfrbung des Lichtes
#define LfpGreen skill3
#define LfpRed skill4
#define LfpRadius skill5			// Radius des Lichtes, in der Flares erkennbar sind
#define LfpMaxDustAlpha skill6	// Maximal Alpha der Dust-Flares
#define LfpMaxLightAlpha skill7	// Maximal Alpha der Lichter selbst
#define LfpOrderId skill8			// Reihenfolge der Lichter mit gleicher Gruppe
#define LfpMaxAuraAlpha skill9	// Maximal Alpha der Licht-Aura (sollte kleiner sein als LfpMaxDustAlpha. Je mehr Lichter zusammen sind, desto kleiner der Wert)
#define LfpLightDistCtrl skill11 // Steuert das Erscheinen der Flares etwas genauer, indem mit diesem Skill multipliziert wird 

#define LfpHasDirtyFlares FLAG8





/* View-Ent-Modus */
#define LfpModeD 0 	// Plaziert die View-Ents mittig
#define LfpModeX 1 	// Plaziert die View-Ents im X-Modus (Zustzliche X-Bewegung)
#define LfpModeXY 2 	// Plaziert die View-Ents im XY-Modus (Zustzliche XY-Bewegung)
#define LfpModeXYP 3	// Plaziert die View-Ents im normalen Modus (XY-Achsenbewegung + Pivot + halbe Bildschirmlnge)


/* Lichtgruppen */
#define LfpLTypeLong 1
	#define LfpNeonPipe1 1
	#define LfpNeonPipe2 2
	#define LfpNeonPipe3 3

#define LfpLTypePoint 2
	#define LfpSun1 2
	#define LfpSun2 3
	#define LfpLamp1 4
	
#define LfpLTypeWindow 3
	#define LfpWindowRed 1
	#define LfpWindowWhite 2





// Helper
MATERIAL* LfpMatCreate(int pow, var* spec, var* diff, var* amb);

// Initialisierung & Cleanup
int LfpGetGrpId(ENTITY* ent, char* string1, char* string2, bool isSubGrp);
char* LfpGetGrpText(int id, bool isSubGrp);
int LfpGrpExist(LfpGroup* lfpGrps, int count, int id);
int LfpSubGrpExist(LfpGroup* lfpGrps, int index, int id);
void LfpAddLight(ENTITY* et, char* mainGroup, char* subGroup, var vertexNum);
void LfpAddLight(ENTITY* et, var vertexNum);
void LfpAddLight(ENTITY* et);
void LfpInitialize(ENTITY** ents, int count);
void LfpInitialize();
void LfpStartLights();
void LfpCleanUp();

// Dust & Dirty
void LfpCtrlDirtyFlares(LfpLight* light);
var* LfpCreateDirtyFlares(LfpLight* light);
void LfpDeleteDirtyFlares(LfpLight* light);

// Flare-Steuerung
void LfpCtrlLightsGrpPointAdd1(ENTITY* ent, ENTITY* entFlare, int index, var val1, var val2);
void LfpCtrlLightsGrpPointAdd2(ENTITY* ent, ENTITY* entFlare, int index, var val1, var val2);
void LfpPlace(ENTITY* ent, var* pos, var mode);
void LfpSetLightFlareColor(var* src, LfpLight* light, var* colors);
var LfpCreateLightFlare(char* name, var layer, var pd, var* scale, var axisPdRl, var axisPdUd);
void LfpDeleteLightFlares(LfpLight* light);
var* LfpCreateLightFlares(LfpLight* light);
void LfpPlaceLightFlare(ENTITY* ent, ENTITY* entFlare, int mainId, int subId, int index);
void LfpControlLightFlare(ENTITY* ent, ENTITY* entFlare,int mainId, int subId, int index);
void LfpAlphaLightFlare(ENTITY* ent, ENTITY* entFlare,int mainId, int subId, int index);
void LfpControlAllLightFlareEffects(LfpLight* light, bool blendOut);

// Aura
void LfpControlLightAuras(LfpLight* light);
ENTITY* LfpCreateLightAura(LfpLight* light,var layer, char* name);
ENTITY* LfpCreateLightAura(LfpLight* light);
void LfpSetLightAuraMaterial(LfpLight* light);

// Lights
void LfpControlLightBlending(LfpLight* light, var dist);
void LfpControlLights(LfpLight* light, var dist);
void LfpSetLightMaterial(LfpLight* light);
void LfpSetLightParent(LfpLight* light);
void LfpDeleteLightResources(LfpLight* light);
void LfpCreateLight(LfpLight* light);


#endif